/*********************************************
 *						                     *
 * ļ: 04 \05 WordIndexTable         *
 * 							                 *
 * ļ: WordIndexTable.c                  *
 * 				     		                 *
 *   : 4.94.104.114.124.134.14 *
 *                                           *
 *********************************************/

#ifndef WORDINDEXTABLE_C
#define WORDINDEXTABLE_C

#include "WordIndexTable.h"					//**04 **//

/*TTTT[
U 㷨4.9U 
^TTTT*/
void Main(char *bookinfo, char *bookidx)
{
	FILE *f, *g;
	char b[MaxLineLen];						//Ŀʱ
	IdxListType idxlist;					//ؼ 
	int i;
	LElemType_E bno;						//	
	
	if(f=fopen(bookinfo, "r"))				//ֻģʽĿļ 
	{
		if(g=fopen(bookidx,  "w"))
		{
			InitIdxList(&idxlist);			//ʼ 
			
			fgets(b, MaxLineLen, f);		//ļһ 
			
			while(!feof(f))					//ʼȡļf 
			{
				GetLine(f);					//ļfһĿϢĿgBuf		
				
				ExtractKeyWord(&bno); 		//gBufȡؼʵʱgWdListŴbno
				
				InsIdxList(&idxlist, bno); 	//żӦĹؼʲidxlist
			}
			
			PutText(g, idxlist);			//gд 			
		}
	}
	
	fclose(g);
	fclose(f);								//رļ	
}

void InitIdxList(IdxListType *idxlist)
{
	char *chars = "ؼ            ";		//Ϊıͷ 
	
	StrAssign_H(&((*idxlist).item[0].key), chars);
	InitList_E(&((*idxlist).item[0].bnolist));
	
	(*idxlist).num = 0;								//ͷΪ0Ϣ 
}

void GetLine(FILE *f)
{
	int len; 

	fgets(gBuf, MaxLineLen, f);				//˴ҪȡbΪַ飬Ϊַָ

	len = strlen(gBuf);						//зĳ 
	
	gBuf[len-1] = '\0';						//з'\0'ȡ 
}

void ExtractKeyWord(int *bno)
{
	char *title;
	FILE *fp;	
	
	*bno = strtol(gBuf, &title, 10);							//ַֽgBufŴbnotitle	
	strlwr(title); 												//дСд
		
	fp = tmpfile();												//ʱļ 
	fprintf(fp, "%s", title);									//ַдʱļ 
	fseek(fp, 0, SEEK_SET);										//ļָƵʼλ 	

	for(gWdList.last=0; gWdList.last<MaxWordNum; gWdList.last++)
	{
		gWdList.str[gWdList.last] = (char*)malloc(MaxLineLen*sizeof(char));
		if(!gWdList.str[gWdList.last])
			exit(OVERFLOW);
																//ʱļжȡַ 
		if(fscanf(fp, "%s", gWdList.str[gWdList.last])==EOF)	//ȡʧ˳ѭ 
			break;
	}		
}

/*TTTTT[
U 㷨4.10 U 
^TTTTT*/
Status InsIdxList(IdxListType *idxlist, int bno)
{
	int i, j;
	Bool boo;
	HString wd;
	
	if(!gWdList.last)
		return ERROR;

	for(i=0; i<gWdList.last; i++)
	{		
		GetWord(i, &wd);							//öѴwdȡؼʴʱiַ
		
		if(!isCommonWords(wd))						//˹ؼʲǳôʣҪв 
		{			
			j = Locate(*idxlist, wd, &boo);
	
			if(boo==FALSE)							//ǰؼʲУ˹ؼ
				InsertNewKey(idxlist, j, wd);

			if(!InsertBook(idxlist, j, bno))		// 
				return ERROR;				
		}		
	}
	return OK;
}

void PutText(FILE *g, IdxListType idxlist)
{
	int i, j, m, n;
	Link p;
	HString S;
	ELinkList L;
	
	for(i=0; i<=idxlist.num; i++)
	{
		S = idxlist.item[i].key;					//ؼ 
		for(m=0; m<S.length; m++)
			fprintf(g, "%c", S.ch[m]);
		
		if(i)										//Ǳͷ 
		{
			for(j=1; j<=18-idxlist.item[i].key.length; j++)		//һĿո 
				fprintf(g, " ");
			
			L = idxlist.item[i].bnolist;			// 
			for(n=1,p=L.head->next; n<=L.len; n++)
			{
				fprintf(g, "%03d", p->data);
				p = p->next;
				if(p)
					fprintf(g, "");
			}
		}
		
		if(i!=idxlist.num)							//δһ 
			fprintf(g, "\n");			
	}	
	
}

/*TTTTT[
U 㷨4.11 U 
^TTTTT*/
void GetWord(int i, HString *wd)
{
	char *p = gWdList.str[i];
	
	StrAssign_H(wd, p);	
}

/*TTTTT[
U 㷨4.12 U 
^TTTTT*/
int Locate(IdxListType idxlist, HString wd, Bool *b)
{
	int i, m;
	
	for(i=idxlist.num; i>0 && (m=StrCompare_H(idxlist.item[i].key,wd))>0; i--);
	
	if(m==0 && idxlist.num!=0)
	{
		*b = TRUE;
		return i;
	}
	else
	{
		*b = FALSE;
		return i+1;
	}	
}

/*TTTTT[
U 㷨4.13 U 
^TTTTT*/
void InsertNewKey(IdxListType *idxlist, int i, HString wd)
{
	int j;
	
	for(j=(*idxlist).num; j>=i; j--)					// 
		(*idxlist).item[j+1] = (*idxlist).item[j];

	StrCopy_H(&((*idxlist).item[i].key), wd);			//
	
	(*idxlist).num++;									//Ŀһ 

	InitList_E(&((*idxlist).item[i].bnolist)); 
}

/*TTTTT[
U 㷨4.14 U 
^TTTTT*/
Status InsertBook(IdxListType *idxlist, int i, LElemType_E bno)
{
	Link p;	

	if(!MakeNode_E(&p, bno))							//ʧ 
		return ERROR;

	Append_E(&((*idxlist).item[i].bnolist), p);			//µ

	return OK;
}

Status isCommonWords(HString S)				//˴ַָ޿ַβ 
{											//ôʴʱеַпַβ 
	int i, len;
	char a[S.length+1];
	Status flag = FALSE;
	
	for(i=0; i<S.length; i++)
		a[i] = S.ch[i];
	a[i] = '\0';
		
	for(i=0; i<gWordList.last; i++)
	{ 	
		if(!strcmpi(a, gWordList.str[i]))	//ַкԴСдıȽ 
		{
			flag = TRUE;
			break;							//ַ˳ѭ 
		}
	}
	
	return flag;
}

#endif
